Attribute VB_Name = "modLocalCommands"
Option Explicit

Public Function parseInBotCommand(ByRef strCommand As String) As Boolean
    
    If (Left$(strCommand, 1) = "/") Then
        'Bare string (Ex: 'uptime -idle; uptime -system')
        Dim FullLengthCommand   As String
        'Array of semi-colon delimited commands (Ex: 'uptime -idle' [0], 'uptime -system' [1])
        Dim DelimCommand()      As String
        'Array of total space-delimited commands for one element of DelimCommand (Ex: 'uptime' [0] '-idle' [1])
        Dim SingleCommand()     As String
        'Any commands that use more than one argument such as /alias :P
        Dim CommandArgs()    As String
        
        'Setup
        ReDim DelimCommand(0)
        ReDim SingleCommand(0)
        ReDim CommandArgs(0)
        parseInBotCommand = True 'If it remains true that means an inbot command has occured and we shouldn't send a message.
        
        FullLengthCommand = Mid$(strCommand, 2)
        If (InStr(FullLengthCommand, ";")) Then
            DelimCommand() = Split(FullLengthCommand, "; ")
        Else
            DelimCommand(0) = FullLengthCommand
        End If
        
        'Begin Multi-Command-Parsing:
        Dim i As Integer
        
        For i = 0 To UBound(DelimCommand)
            'Setup
            If (InStr(DelimCommand(i), Space(1))) Then
                'SingleCommand(1) should possess all argument data as the array limit is 2.
                SingleCommand() = Split(DelimCommand(i), Space(1), 2)
            Else 'No spaces (Ex: 'Uptime')
                SingleCommand(0) = DelimCommand(i)
            End If
            
            'Raw command parsing:
            Select Case LCase$(SingleCommand(0))
            
                    Case "profile"
                        If (UBound(SingleCommand) > 0) Then
                            frmProfile.setUsername SingleCommand(1)
                            With ConnectionHandler
                                Call .BNCSHandler.setClassVars(BotIndex, frmMain.sckBNET(BotIndex))
                                Call .BNCSHandler.sendSID_READUSERDATA(SingleCommand(1))
                            End With
                        Else
                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "Error: Please specify a username."
                        End If
                    
                    Case "join"
                        If (UBound(SingleCommand) > 0) Then
                            With ConnectionHandler
                                Call .BNCSHandler.setClassVars(BotIndex, frmMain.sckBNET(BotIndex))
                                Call .BNCSHandler.sendSID_JOINCHANNEL(SingleCommand(1))
                            End With
                        End If
                    
                    Case "rejoin"
                        With ConnectionHandler
                            Call .BNCSHandler.setClassVars(BotIndex, frmMain.sckBNET(BotIndex))
                            Call .BNCSHandler.sendSID_LEAVECHAT
                            Call .BNCSHandler.sendSID_JOINCHANNEL(Bots(BotIndex).CurrentChannel)
                        End With
                    
                    Case "recorddata"
                        With ConnectionHandler
                            Call .BNCSHandler.setClassVars(BotIndex, frmMain.sckBNET(BotIndex))
                            Call .BNCSHandler.sendSID_READUSERDATA(vbNullString)
                        End With
                        
                    Case "clear"
                        Select Case LCase$(SingleCommand(1))
                            Case "whisper"
                            Case "chat"
                            Case "queue"
                        End Select
                    
                    Case "window"
                    
                    Case "debugmode"
                        Select Case LCase$(SingleCommand(1))
                            Case "on"
                                G_Options.Debug_Mode = True
                                AddC BotIndex, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, "Debug mode has been engaged."
                            Case "off"
                                G_Options.Debug_Mode = False
                                AddC BotIndex, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Debug mode has been disengaged."
                        End Select
                        
                    Case "reply"
                        If (UBound(SingleCommand) > 0) Then
                            AddQueue BotIndex, "/w " & Bots(BotIndex).LastWhisperUser & Space(1) & SingleCommand(1)
                        End If
                    
                    Case "changeprofile"
                        If (UBound(SingleCommand) > 0) Then
                            Dim ProfileIndex    As Integer
                            ProfileIndex = getProfileIndex(SingleCommand(1))
                            If (ProfileIndex = -1) Then
                                AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_ERROR, "Error: Invalid profile name."
                            Else
                                frmMain.tsBotsList.Tabs(ProfileIndex + 1).Selected = True 'Calls SwitchProfile
                            End If
                        End If
                    
                    Case "realm"
                        If Bots(BotIndex).Client = PRODUCT_D2DV Or Bots(BotIndex).Client = PRODUCT_D2XP Then
                            With ConnectionHandler.MCPHandler
                                Call .setClassVars(BotIndex, frmMain.sckREALM(BotIndex))
                                .sendMCP_CHARLIST2
                            End With
                        End If
                    
                    Case "alias"
                        '/alias add <alias> <command>
                        If (UBound(SingleCommand) > 0) Then
                            If InStr(SingleCommand(1), Space(1)) Then
                                CommandArgs() = Split(SingleCommand(1), Space(1), 3)
                            Else
                                CommandArgs(0) = SingleCommand(1)
                            End If
                            
                            If UBound(CommandArgs) > 1 Then
                                Select Case LCase$(CommandArgs(0))
                                    Case "add"
                                        If BotAliases.addAlias(CommandArgs(1), CommandArgs(2)) Then
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_SUCCEED, "Command alias added."
                                        Else
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "Failed to add command alias."
                                        End If
                                        
                                    Case "remove"
                                        If BotAliases.removeAlias(CommandArgs(1)) Then
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_SUCCEED, "Command alias removed."
                                        Else
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "Failed to remove command alias."
                                        End If
                                End Select
                            Else
                                AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "ERROR: Invalid syntax."
                            End If
                        Else
                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "ERROR: Invalid syntax."
                        End If
                        
                    Case "userfilter"
                        If (UBound(SingleCommand) > 0) Then
                            If InStr(SingleCommand(1), Space(1)) Then
                                CommandArgs() = Split(SingleCommand(1), Space(1), 2)
                            Else
                                CommandArgs(0) = SingleCommand(1)
                            End If
                            
                            If UBound(CommandArgs) > 0 Then
                                Select Case LCase$(CommandArgs(0))
                                    Case "add"
                                        If BotFilters.addFilter(CommandArgs(1), F_USER) Then
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_SUCCEED, "User filter added: " & CommandArgs(1)
                                        Else
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "Failed to add user filter."
                                        End If
                                        
                                    Case "remove"
                                        If BotFilters.removeFilter(CommandArgs(1), F_USER) Then
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_SUCCEED, "User filter removed: " & CommandArgs(1)
                                        Else
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "Failed to remove user filter."
                                        End If
                                End Select
                            Else
                                AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "ERROR: Invalid syntax. (/userfilter (add/remove) <filter>)"
                            End If
                        Else
                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "ERROR: Invalid syntax."
                        End If
                        
                    Case "messagefilter"
                        If (UBound(SingleCommand) > 0) Then
                            If InStr(SingleCommand(1), Space(1)) Then
                                CommandArgs() = Split(SingleCommand(1), Space(1), 2)
                            Else
                                CommandArgs(0) = SingleCommand(1)
                            End If
                            
                            If UBound(CommandArgs) > 0 Then
                                Select Case LCase$(CommandArgs(0))
                                    Case "add"
                                        If BotFilters.addFilter(CommandArgs(1), F_MESSAGE) Then
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_SUCCEED, "Message filter added: " & CommandArgs(1)
                                        Else
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "Failed to add message filter."
                                        End If
                                        
                                    Case "remove"
                                        If BotFilters.removeFilter(CommandArgs(1), F_MESSAGE) Then
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_SUCCEED, "Message filter removed: " & CommandArgs(1)
                                        Else
                                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "Failed to remove message filter."
                                        End If
                                End Select
                            Else
                                AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "ERROR: Invalid syntax. (/messagefilter (add/remove) <filter>)"
                            End If
                        Else
                            AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "ERROR: Invalid syntax."
                        End If
                    
                    Case "uptime"
                        If (UBound(SingleCommand) > 0) Then
                            Select Case LCase$(SingleCommand(1))
                                Case "system"
                                    AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] System: " & FormatGTC(GetTickCount())
                                Case "application"
                                    If (UPTIME_APPLICATION <> 0) Then
                                        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] Application: " & FormatGTC(GetTickCount() - UPTIME_APPLICATION)
                                    End If
                                Case "connection"
                                    If (ProfileHandler(BotIndex).UPTIME_CONNECTION <> 0) Then
                                        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] Connection: " & FormatGTC(GetTickCount() - ProfileHandler(BotIndex).UPTIME_CONNECTION)
                                    End If
                                Case "idle"
                                    If (ProfileHandler(BotIndex).UPTIME_IDLE <> 0) Then
                                        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] Idle: " & FormatGTC(GetTickCount() - ProfileHandler(BotIndex).UPTIME_IDLE)
                                    End If
                                Case "inchannel"
                                    If (ProfileHandler(BotIndex).UPTIME_INCHANNEL <> 0) Then
                                        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] Inchannel: " & FormatGTC(GetTickCount() - ProfileHandler(BotIndex).UPTIME_INCHANNEL)
                                    End If
                                Case "all" '**NOTE: Need to make this more efficient rather then repeating code.
                                    AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] System: " & FormatGTC(GetTickCount())
                                    If (UPTIME_APPLICATION <> 0) Then
                                        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] Application: " & FormatGTC(GetTickCount() - UPTIME_APPLICATION)
                                    End If
                                    If (ProfileHandler(BotIndex).UPTIME_CONNECTION <> 0) Then
                                        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] Connection: " & FormatGTC(GetTickCount() - ProfileHandler(BotIndex).UPTIME_CONNECTION)
                                    End If
                                    If (ProfileHandler(BotIndex).UPTIME_IDLE <> 0) Then
                                        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] Idle: " & FormatGTC(GetTickCount() - ProfileHandler(BotIndex).UPTIME_IDLE)
                                    End If
                                    If (ProfileHandler(BotIndex).UPTIME_INCHANNEL <> 0) Then
                                        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "[Uptime] Inchannel: " & FormatGTC(GetTickCount() - ProfileHandler(BotIndex).UPTIME_INCHANNEL)
                                    End If
                                Case Else
                                    AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "Error: Please specify a correct tag: -all, -system, -application, -connection, -inchannel, or -idle. (Example: uptime -all)"
                            End Select
                        End If
                
                    Case Else
                        parseInBotCommand = False
            End Select
        Next i
    Else
        parseInBotCommand = False
    End If
End Function
